# -*- coding: UTF-8 -*-

# 2022-08-28
# edit 2025-08-28

import os, sys
import json, re
import xbmc, xbmcgui, xbmcaddon, xbmcvfs

from resources.lib import utils, updateManager

Addon = xbmcaddon.Addon()
AddonName = Addon.getAddonInfo('name')
AddonId = Addon.getAddonInfo('id')

is_python2 = sys.version_info.major == 2
def translatePath(*args):
    if is_python2: return xbmc.translatePath(*args).decode("utf-8")
    else: return xbmcvfs.translatePath(*args)

ADDON_DATA_DIR = translatePath(os.path.join('special://home/userdata/addon_data', '%s')) # plugin_id
ADDON_PATH = translatePath(os.path.join('special://home/addons/', '%s'))
INSTALL_CONTROL = translatePath(os.path.join(Addon.getAddonInfo('profile'), "addons_installed"))

STATUS = 0
silent=True

def getSettings():
    _Addons = []
    # _Addons.append(('script.module.resolveurl', 'master'))  # immmer überprüfen
    for i in ['resolveurl', 'xship', 'xstream', 'mediathekviewweb', 'xsplayer']:   # 'resolveurl','vavooto',
        if Addon.getSetting('update.%s' %i) == 'true':
            if i == 'resolveurl':
                _Addons.append(('script.module.resolveurl', 'master'))
            if i == 'xship':
                _Addons.append(('plugin.video.%s' % i, 'master'))
            elif i == 'xstream':
                _Addons.append(('plugin.video.%s' % i, 'master'))
            elif i == 'mediathekviewweb':
                _Addons.append(('plugin.video.%s' % i, 'master'))
            # elif i == 'vavooto':
            #     _Addons.append(('plugin.video.%s' % i, 'master'))
            elif i == 'xsplayer':
                _Addons.append(('script.module.%s' % i, 'master'))
        else: Addon.setSetting('update.%s' %i,'false')

    ADDONIDS = []
    for i in _Addons:
        ADDONIDS.append(i[0])
    ADDONIDS = set(ADDONIDS)

    return _Addons, ADDONIDS

def script_module_resolveurl(ADDONID,branch='master'):
    username = 'Gujal00'
    plugin_id = 'ResolveURL'
    #branch = 'master'
    token = '' # Addon.getSetting('service.git_token')
    return updateManager.Update(username, plugin_id, branch, token, silent)

def plugin_video_xship(ADDONID,branch='master'):
    username = Addon.getSetting('service.username')
    plugin_id = ADDONID
    branch = 'development'
    token = Addon.getSetting('service.git_token')
    return updateManager.Update(username, plugin_id, branch, token, silent)

def plugin_video_xstream(ADDONID,branch='direct'):
    username = Addon.getSetting('service.username.own')
    plugin_id = f"{ADDONID}-new"
    branch = 'master'
    token = Addon.getSetting('service.git_token.own')
    return updateManager.Update(username, plugin_id, branch, token, silent)

def plugin_video_mediathekviewweb(ADDONID,branch='master'):
    username = Addon.getSetting('service.username')
    plugin_id = ADDONID
    #branch = 'master'
    token = Addon.getSetting('service.git_token')
    return updateManager.Update(username, plugin_id, branch, token, silent)

def plugin_video_vavooto(ADDONID,branch='master'):
    username = Addon.getSetting('service.username')
    plugin_id = ADDONID
    #branch = 'master'
    token = Addon.getSetting('service.git_token')
    return updateManager.Update(username, plugin_id, branch, token, silent)

def script_module_xsplayer(ADDONID,branch='master'):
    username = Addon.getSetting('service.username')
    plugin_id = ADDONID
    #branch = 'master'
    token = Addon.getSetting('service.git_token')
    return updateManager.Update(username, plugin_id, branch, token, silent)

# ------------------------------------

def setSettingFalse(AddonID=None):
    if AddonID == 'service.xS.versioncheck':
        Addon.setSetting(id='service.autoupdate', value='false')
    else:
        Addon.setSetting(id='update.%s' % AddonID.split('.')[2], value='false')


def _status(status):
    global STATUS
    # print (STATUS)
    if status == False: status = 2
    elif status == True: status = 1
    else: status = 0 #None
    if status > STATUS: STATUS = status
    # print (STATUS)

def main():
    _Addons, ADDONIDS = getSettings()
    check_addons = None
    if not _Addons: return None

    ADDONS = []
    for i in _Addons:
        ADDONS.append(i[0])
        # print(i)
    ADDONS = set(ADDONS)

    if os.path.isfile(INSTALL_CONTROL) == False: check_addons = True
    if check_addons != True:
        for ADDONID in ADDONS:
            if os.path.isdir(ADDON_PATH % ADDONID) == False:
                check_addons = True
                # if ADDONID == 'plugin.video.xstream'and os.path.isdir('repository.xstream') == False:
                #     check_addons = False    # dann muss erst das xstream repo installiert werden

    if check_addons != True:
        for ADDONID in ADDONS:
            try:
                struktur = json.loads(xbmc.executeJSONRPC('{"jsonrpc":"2.0","method":"Addons.GetAddonDetails","id":1,"params": {"addonid":"%s", "properties": ["enabled"]}}' % ADDONID))
                if struktur["result"]["addon"]["enabled"] != True: check_addons = True
            except:
                check_addons = True
                pass

    if check_addons == True:
        utils.infoDialog("Überprüfe Installation", sound=False, icon='INFO', time=10000000)
        # TODO
        # utils.enableAddon(ADDONID)
        Addon.setSetting(id='service.reloadProfil', value='true')
    else:
        utils.infoDialog("Suche Updates", sound=False, icon='INFO', time=10000000)

    for i in _Addons:
        ADDONID = i[0]
        if Addon.getSetting('update.enforceUpdate') == 'true':
            LOCAL_PLUGIN_VERSION = os.path.join(ADDON_DATA_DIR % ADDONID, "update_sha")
            if os.path.exists(LOCAL_PLUGIN_VERSION): os.remove(LOCAL_PLUGIN_VERSION)
        try:
            branch = i[1]
            cmd = ADDONID.replace('.', '_') + '("' + ADDONID + '", "'+ branch + '")'
        except:
            cmd = ADDONID.replace('.', '_') + '("' + ADDONID + '")'

        status = eval(cmd)
        if status == 'auth-error':
            xbmcgui.Dialog().ok(AddonName, 'Fehler beim Update "[B]' + ADDONID + '[/B]"\n[COLOR red]Update-Key abgelaufen oder ungültig![/COLOR]\nAutoUpdate wird deaktiviert!')
            setSettingFalse(ADDONID)
            #utils.infoDialog("Auto Update mit Fehler beendet", sound=True, icon='ERROR', time=1000)
            #return  'auth-error'
            continue
        utils.checkDependence(ADDONID)
        utils.enableAddon(ADDONID)
        _status(status)

    if check_addons == True:
        if STATUS <= 1:
            open(INSTALL_CONTROL, "w+").write('Addons sind installiert')
            xbmc.sleep(500)
            utils.infoDialog("Vorgang ist abgeschlossen", sound=False, icon='INFO', time=1000)
            if Addon.getSetting('service.reloadProfil') == 'true' and Addon.getSetting('update.xsplayer') == 'false': utils.reload_profile()
        else:
            utils.infoDialog("Vorgang mit Fehler beendet", sound=True, icon='ERROR')

    else:
        if STATUS == 0: utils.infoDialog("Keine neuen Updates gefunden", sound=False, icon='INFO', time=3000)
        elif STATUS == 1:
            utils.infoDialog("Vorgang erfolgreich abgeschlossen", sound=False, icon='INFO', time=1000)
            if Addon.getSetting('service.reloadProfil') == 'true'and Addon.getSetting('update.xsplayer') == 'false': utils.reload_profile()
        else:
            utils.infoDialog("Auto Update mit Fehler beendet", sound=True, icon='ERROR')


if __name__ == '__main__':
    yes = xbmcgui.Dialog().yesno(AddonName, 'Nach Aktualisierungen (Updates) suchen?')
    if yes:
        yes = xbmcgui.Dialog().yesno(AddonName, 'Vor Aktualisierung die Einstellungen aufrufen?')
        if yes: xbmcaddon.Addon().openSettings()

        if Addon.getSetting('service.git_token') == '':
            xbmcgui.Dialog().ok(AddonName, 'Das Addon benötigt Benutzer und Update-Key in den Einstellungen!')
        else:
            main()

